clear

a = 41.6625;
l = 166.65;
B = 75.75;

theta = -180:0.01:180;
phi = 0:20:20;

% InPortH = [0.05 0.2];
% ExPortH = [0.075 0.225];
% x = [-180 180];

figure('Position', [200 80 1000 600])
t = tiledlayout(2,1);
t.TileSpacing = 'none';
t.Padding = 'none';

for i = 1:length(phi)

    IntakePistonPosition(i,:) = (a - l + a*cos((theta-(phi(i)/2))*pi/180) + sqrt(l^2 - a^2*sin((theta-(phi(i)/2))*pi/180).^2))/(2*a);
    ExhaustPistonPosition(i,:) = (a - l + a*cos((theta+(phi(i)/2))*pi/180) + sqrt(l^2 - a^2*sin((theta+(phi(i)/2))*pi/180).^2))/(2*a);

    EffectivePistonPosition(i,:) = IntakePistonPosition(i,:) + ExhaustPistonPosition(i,:);
        
end

% plot(theta, ExhaustPistonPosition(1,:), 'k-.');
hold on
% plot(theta, IntakePistonPosition(1,:), 'k');
h1 = plot(theta, ExhaustPistonPosition(2,:), 'r--');
h2 = plot(theta, IntakePistonPosition(2,:), 'b--');
h3 = plot(theta, EffectivePistonPosition(2,:), 'k--');
h4 = plot(theta, EffectivePistonPosition(1,:), 'k');

xlim([-180 180])
xticks([-180 -90 0 90 180])
% xtickformat('%.1f')
ytickformat('%.1f')
xlabel('Equivalent Crank Angle [deg]')
ylabel({'Normalized Piston Displacement'})
set(gca, 'FontSize', 10)
box on

[p,z] = zoomPlot(theta, EffectivePistonPosition(1,:),[-15 15],[0.2 0.7 0.15 0.15],[1 3]);
hold on
plot(theta, EffectivePistonPosition(2,:), 'k--');
xticks([-15 0 15])
ytickformat('%.2f')
legend([h1 h2 h3 h4],{'Exhaust','Intake','Effective','Without Offset'},'FontSize',10)

